// H.Moessenboeck: Sprechen Sie Java? -- Kapitel 5, Aufgabe 2
// "Berechnung des Arcussinus"

class A2 {
	
	static final double pi = 3.1415926;
	
	public static void main(String[] arg) {
		Out.print("Geben Sie sin(x) ein: ");
		double x = In.readDouble();
		// Every iteration adds a term of the form
		// newTerm = previousTerm * (2 * i - 1)^2 * x^2 / (2 * i * (2 * i + 1))
		double res  = x;     // result for i == 0
		double t    = x;     // term added in previous iteration
		double x2   = x * x; // x^2
		double a    = - 1.0; // 2 * i - 1
		double b    = 1.0;   // 2 * i + 1
		for (int i = 1; i < 100; i++) {
			a = a + 2.0;
			b = b + 2.0;
			double d = (a * a * x2) / (b * i * 2);
			t = t * d;
			res = res + t;
		}
		Out.println("arcsin(x) = " + res + " in Radianten = " + (res * 180.0 / pi) + " in Grad");
	}
}


/*  Besser mit Methoden:

class A2 {
	
	static final double pi = 3.1415926;
	
	static double arcsin(double x) {
		// Every iteration adds a term of the form
		// newTerm = previousTerm * (2 * i - 1)^2 * x^2 / (2 * i * (2 * i + 1))
		double res  = x;     // result for i == 0
		double t    = x;     // term added in previous iteration
		double x2   = x * x; // x^2
		double a    = - 1.0; // 2 * i - 1
		double b    = 1.0;   // 2 * i + 1
		for (int i = 1; i < 100; i++) {
			a = a + 2.0;
			b = b + 2.0;
			double d = (a * a * x2) / (b * i * 2);
			t = t * d;
			res = res + t;
		}
		return res;
	}
	
	public static void main(String[] arg) {
		Out.print("Geben Sie sin(x) ein: ");
		double x = In.readDouble();
		double res = arcsin(x);
		Out.println("arcsin(x) = " + res + " in Radianten = " + (res * 180.0 / pi) + " in Grad");
	}
}

*/